//
//  UserProfileViewController1.swift
//  UaePassDemo
//
//  Created by Mohammed Gomaa on 12/30/18.
//  Copyright © 2018 Mohammed Gomaa. All rights reserved.
//

import UIKit
import WebKit
import UAEPassClient

public class UserProfileViewController: UIViewController,  UIDocumentInteractionControllerDelegate, WKNavigationDelegate {
    @IBOutlet var labelName: UILabel!
    @IBOutlet var labelEmail: UILabel!
    @IBOutlet var labelMobile: UILabel!
    @IBOutlet var labelDateOfBirth: UILabel!
    @IBOutlet var labelNationality: UILabel!
    
    @objc var webView: WKWebView?

    var userProfile: UAEPassUserProfile!
    @objc public var userToken: String!
    public var pdfName: String?
    public var pdfID: String?

    var successURLR: String?
    var failureURLR: String?
    public override func viewDidLoad() {
        self.title = "Profile"
        self.labelName.text = self.userProfile.firstnameEN
        self.labelEmail.text = self.userProfile.email
        self.labelMobile.text = self.userProfile.mobile
        self.labelDateOfBirth.text = self.userProfile.dob
        self.labelNationality.text = self.userProfile.nationalityEN
        webView?.isHidden = true
    }
    
    public func forceReload() {
        print("<<<<<<<<<<<<<<< foreceReload From AppDelegate >>>>>>>>>>>>>>>>>>")
        if let successurl = successURLR {
            UAEPASSRouter.shared.webView.load(URLRequest(url: URL(string: successurl)!))
        } else {
            UAEPASSRouter.shared.webView.reload()
        }
    }
    
    public func foreceStop() {
        print("<<<<<<<<<<<<<<< foreceStop From AppDelegate >>>>>>>>>>>>>>>>>>")
        UAEPASSRouter.shared.webView.stopLoading()
    }
    
    public func webView(_: WKWebView, decidePolicyFor navigationAction: WKNavigationAction, decisionHandler: @escaping (WKNavigationActionPolicy) -> Void) {
        var action: WKNavigationActionPolicy?
        defer {
            decisionHandler(action ?? .allow)
        }
        guard let urlString = navigationAction.request.mainDocumentURL?.absoluteString else { return }
        
        print(">>>> URL STRING : \(urlString)")
        if urlString.contains("error=access_denied") {
            self.view.removeBluerLoader()
            webView?.isHidden = true
        } else if urlString.contains("uaepass://") {
            let newURLString = urlString.replacingOccurrences(of: "uaepass://", with: UAEPASSRouter.shared.environmentConfig.uaePassSchemeURL)
            successURLR = navigationAction.request.mainDocumentURL?.valueOf("successurl")
            failureURLR = navigationAction.request.mainDocumentURL?.valueOf("failureurl")
            let listItems = newURLString.components(separatedBy: "successurl")
            if listItems.count > 0 {
                if let customScheme = listItems.first {
                    let successScheme = HandleURLScheme.externalURLSchemeSuccess()
                    let failureScheme = HandleURLScheme.externalURLSchemeFail()
                    let urlScheme = "\(customScheme)successurl=\(successScheme)&failureurl=\(failureScheme)&closeondone=true"
                    print("urlScheme: \(urlScheme)")
                    HandleURLScheme.openCustomApp(fullUrl: urlScheme)
                }
            }
        } else if urlString.contains("status=finished") {
            self.view.removeBluerLoader()
            webView?.isHidden = true
            self.view.showBlurLoader()
            UAEPASSNetworkRequests.shared.downloadSignedPdf(pdfID: pdfID ?? "", pdfName: "sample.pdf", completion: { (filePath, _) in
                self.view.removeBluerLoader()
                if let url = URL(string: filePath) {
                    self.showPDFFile(fileURL: url) 
                }
            }, onError: { error in
                self.view.removeBluerLoader()
            })
        } else if urlString.contains("status=") {
            self.view.removeBluerLoader()
            webView?.isHidden = true
        }
    }
    
    @IBAction func faceAuthentication(_ sender: Any) {
        #warning("your own client and secret for face verification is required.")
        UAEPASSRouter.shared.environmentConfig = UAEPassConfig(clientID: "sample_mobile_app_fv", clientSecret: "sm@rtdubai@123", env: UAEPASSRouter.shared.environmentConfig.env)
        self.view.showBlurLoader()
        self.view.removeBluerLoader()
        if let webVC = UAEPassWebViewController.instantiate() as? UAEPassWebViewController {
            webVC.urlString = UAEPassConfiguration.getServiceUrlForType(serviceType: .faceAuthLoginURL)
            webVC.onUAEPassSuccessBlock = {(code: String?) -> Void in
                self.navigationController?.dismiss(animated: true)
                if let code = code {
                    self.view.makeToast("Code: \(code)")
                }
            }
            webVC.onUAEPassFailureBlock = {(response: String?) -> Void in
                self.navigationController?.dismiss(animated: true)
            }
            webVC.reloadwithURL(url: webVC.urlString)
            self.navigationController?.present(webVC, animated: true)
        }
    }
    
    @IBAction func signDocument(_ sender: Any) {
        // download and start signing
        print("download and start signing")
        let bundle = Bundle(for: type(of: self))
        guard let uaePassSigningParameters = ReadJSONHelper().getUAEPAssSigningParametersFrom(fileName: "testSignData", bundle) else { return }
        
        let downloadUrl: String = "https://unec.edu.az/application/uploads/2014/12/pdf-sample.pdf"
        let fileName = "sample.pdf"
        self.view.showBlurLoader()
        UAEPASSNetworkRequests.shared.downloadPdf(pdfName: fileName, documentURL:downloadUrl, completion: { (filePath, _) in
            var requestData = UAEPassSigningRequest()
            requestData.serviceType = UAEPassServiceType.tokenTX
            requestData.tokenParams = TokenParams.getInitialisedObject()
            requestData.processParams = uaePassSigningParameters
            
            UAEPASSNetworkRequests.shared.generateSigningToken(requestData: requestData, completion: { response in
                if response == "DONE" {
                    UAEPASSNetworkRequests.shared.uploadDocument(requestData: requestData, pdfName: fileName) { response, success in
                        self.view.removeBluerLoader()
                        if let response = response,let document = response.documents?.first, let content = document.content, success == true {
                            if let range = content.range(of: "documents/") {
                                let pdfName = content[range.upperBound...].trimmingCharacters(in: .whitespaces)
                                self.pdfName = pdfName
                                let pdfID = response.documents?[0].content?.slice(from:"documents/", to: "/content") ?? ""
                                self.pdfID = pdfID
                                UAEPASSRouter.shared.uploadSignDocumentResponse = response
                                self.loadUAEPASSWebView(stringURL: response.tasks?.pending?.first?.url ?? "")
                            }
                        } else {
                            // error
                        }
                    }
                }
            }, onError: { error in
                self.view.removeBluerLoader()
            })

        }, onError: { error in
            self.view.removeBluerLoader()
        })
    }

    
    @objc func loadUAEPASSWebView(stringURL: String) {
        webView?.isHidden = false
        webView = UAEPASSRouter.shared.webView
        webView?.navigationDelegate = self
        webView?.scrollView.isScrollEnabled = false
        webView?.scrollView.showsHorizontalScrollIndicator = false
        webView?.scrollView.showsVerticalScrollIndicator = false
        webView?.frame = self.view.frame
        if let url = URL(string: stringURL), let webView = webView {
            let urlRequest = URLRequest(url: url)
            webView.load(urlRequest)
            _ = view.addSubviewStretched(subview: webView)
        }
    }
    
    // MARK: - SHOW PDF FILE -
    func showPDFFile(fileURL: URL) {
        webView?.isHidden = true
        let documentController = UIDocumentInteractionController(url: fileURL)
        documentController.delegate = self
        documentController.presentPreview(animated: true)
    }
    // MARK: - UIDocumentInteractionController delegates -
    public func documentInteractionControllerViewControllerForPreview(_: UIDocumentInteractionController) -> UIViewController {
        return self
    }
}

