# UAE Pass Demo App

UAE Pass Demo App is a sample app to show you how to use UAE Pass for :

- App to app login.
- Login with WebView inside the app .. incase if UAE Pass not installed in the same device.
- Getting user profile details.
- Download smaple document.
- Sign donwnloaded document.
- View signed document.

# 1- Framework setup !

- Create LocalPods folder if you don't have it.
- Add UAEPPASSClient folder in LocalPods folder. 
- Add   pod 'UAEPassClient', :path => "LocalPods/UAEPassClient" to your podfile. 

# 2- Should do !
- In AppDelegate add below :
-- import UAEPassClient
- In didFinishLaunchingWithOptions add :
--         UAEPASSRouter.shared.spConfig = SPConfig(redirectUriLogin: "client redirect url",
                                         scope: "client login scope",
                                         state: "RANDOM 24 alpha numeric",  //Randomly Generated Code 24 alpha numeric.
                                         successSchemeURL: "UUUUU://", //client success url scheme.
                                         failSchemeURL: "CCCCC://", //client failure url scheme.
                                         signingScope: "urn:safelayer:eidas:sign:process:document") // client signing scop.
--             UAEPASSRouter.shared.environmentConfig = UAEPassConfig(clientID: "your client id", clientSecret: "your client secret", env: .production)
--- env (environment can be : .production or .qa or .dev)
- func application(_: UIApplication, handleOpen url: URL) -> Bool {
    print("<><><><> appDelegate URL : \(url.absoluteString)")
    if url.absoluteString.contains(HandleURLScheme.externalURLSchemeSuccess()) {
        if let topViewController = UserInterfaceInfo.topViewController() {
            if let webViewController = topViewController as? UAEPassWebViewController {
                webViewController.forceReload()
            } 
        }
        return true
    } else if url.absoluteString.contains(HandleURLScheme.externalURLSchemeFail()) {
        guard let webViewController = UserInterfaceInfo.topViewController() as? UAEPassWebViewController  else { return false}
        webViewController.foreceStop()
        let alertController = UIAlertController(title: "Failed to login with UAE PASS Login", message: "Try again later", preferredStyle: .actionSheet)
        let okAction = UIAlertAction(title: "OK", style: UIAlertAction.Style.default) { _ in
            NSLog("OK Pressed")
            webViewController.navigationController?.popViewController(animated: true)
        }
        alertController.addAction(okAction)
        self.window?.rootViewController?.present(alertController, animated: true, completion: nil)
        return false
    }
    return true
}

# 3- Should do !
- Add UAE Pass scheme in your project info.plist in LSApplicationQueriesSchemes (Already added in this sample): 
-- for Production: uaepass
-- for QA: uaepassqa
-- for DEV: uaepassdev

# For more understanding:
- After press on login with uae pass button you will be asked to select which environment you would like to use for login through UIAlertController and from this action you can trace how it works.
- from application(_: UIApplication, handleOpen url: URL) -> Bool in AppDelegate you can force current webview to reload or stop loading incase if success or failure.
- This sample contains three view controllers :
-- ViewController.swift (main screen which contains login button and UIAlertController to select required environment).
-- UserProfileViewController.swift (Just simple view to show user profile details and it contains sign document scneario as well).
-- UAEPassWebViewController.swift (Resposible for handling webView requests to generate uaepass code to use it for token generation).


# Signing flow :
- you should have valid pdf file and in this sample you will be able to see sample code for downloading pdf file. 
- then we have to generate valid token for signing process. 
- then we have to upload above valid pdf document  to uaepass. 
- after uploading we have to send our request for signing for (signature type (advanced or qualified), on which page signature will be placed, signature coordintates and signature size)

# Check !
- testSignData.json is very important file as this is signing info which you should pass to UAE Pass app and it's expected to be recieved from the back end and it's required to be reconfigured to add your own app scheme.

- This sample supports dark mode as well.

**Smart Dubai, SDDTeam**
