//
//  AppDelegate.swift
//  UaePassDemo
//
//  Created by Mohammed Gomaa on 1/3/19.
//  Copyright © 2019 Mohammed Gomaa. All rights reserved.
//

import UIKit
import UAEPassClient

@UIApplicationMain
class AppDelegate: UIResponder, UIApplicationDelegate {
    static let shared = UIApplication.shared.delegate as? AppDelegate
    var window: UIWindow?
    
//    ##### YOU MIGHT HAVE TO USE THIS COMMENTED METHOD for (Flutter, Xamarin....).
//    func application(_ app: UIApplication, open url: URL, options: [UIApplication.OpenURLOptionsKey : Any] = [:]) -> Bool {
//        return true
//    }

    func application(_: UIApplication, handleOpen url: URL) -> Bool {
        print("<><><><> appDelegate URL : \(url.absoluteString)")
        if url.absoluteString.contains(HandleURLScheme.externalURLSchemeSuccess()) {
            if let topViewController = UserInterfaceInfo.topViewController() {
                if let webViewController = topViewController as? UAEPassWebViewController {
                    webViewController.forceReload()
                } 
            }
            return true
        } else if url.absoluteString.contains(HandleURLScheme.externalURLSchemeFail()) {
            guard let webViewController = UserInterfaceInfo.topViewController() as? UAEPassWebViewController  else { return false}
            webViewController.foreceStop()
            return false
        }
        return true
    }
}

